/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityElectricPump
extends TileEntityMekanism
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final int HEAVY_WATER_AMOUNT = 10;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"})
    public BasicFluidTank fluidTank;
    @Nonnull
    private FluidStack activeType = FluidStack.EMPTY;
    public int ticksRequired = 19;
    public int operatingTicks;
    private final Set<BlockPos> recurringNodes = new ObjectOpenHashSet();
    private MachineEnergyContainer<TileEntityElectricPump> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityElectricPump(BlockPos pos, BlockState state) {
        super(MekanismBlocks.ELECTRIC_PUMP, pos, state);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.output(10000, listener);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.drain(this.fluidTank, listener, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(listener, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectricPump)this).m_58904_(), listener, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.drainTank(this.outputSlot);
        if (MekanismUtils.canFunction(this) && (this.fluidTank.isEmpty() || 1000 <= this.fluidTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck()) {
                    this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                } else {
                    this.reset();
                }
            }
        }
        if (!this.fluidTank.isEmpty()) {
            FluidUtils.emit(Collections.singleton(Direction.UP), this.fluidTank, this, 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED)));
        }
    }

    private boolean suck() {
        boolean hasFilter = this.upgradeComponent.isUpgradeInstalled(Upgrade.FILTER);
        for (Direction orientation : EnumUtils.DIRECTIONS) {
            if (!this.suck(this.f_58858_.m_142300_(orientation), hasFilter, true)) continue;
            return true;
        }
        ArrayList<BlockPos> tempPumpList = new ArrayList<BlockPos>(this.recurringNodes);
        Collections.shuffle(tempPumpList);
        for (BlockPos tempPumpPos : tempPumpList) {
            if (this.suck(tempPumpPos, hasFilter, false)) {
                return true;
            }
            for (Direction orientation : EnumUtils.DIRECTIONS) {
                BlockPos side = tempPumpPos.m_142300_(orientation);
                if (!(WorldUtils.distanceBetween(this.f_58858_, side) <= (double)MekanismConfig.general.maxPumpRange.get()) || !this.suck(side, hasFilter, true)) continue;
                return true;
            }
            this.recurringNodes.remove(tempPumpPos);
        }
        return false;
    }

    private boolean suck(BlockPos pos, boolean hasFilter, boolean addRecurring) {
        BlockState blockState;
        FluidState fluidState;
        Optional<BlockState> state = WorldUtils.getBlockState((BlockGetter)this.f_58857_, pos);
        if (state.isPresent() && !(fluidState = (blockState = state.get()).m_60819_()).m_76178_() && fluidState.m_76170_()) {
            Block block = blockState.m_60734_();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (this.validFluid(fluidBlock.drain(this.f_58857_, pos, IFluidHandler.FluidAction.SIMULATE), true)) {
                    this.suck(fluidBlock.drain(this.f_58857_, pos, IFluidHandler.FluidAction.EXECUTE), pos, addRecurring);
                    return true;
                }
            } else if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                Fluid sourceFluid = fluidState.m_76152_();
                FluidStack fluidStack = this.getOutput(sourceFluid, hasFilter);
                if (this.validFluid(fluidStack, false)) {
                    if (sourceFluid != Fluids.f_76193_ || MekanismConfig.general.pumpWaterSources.get()) {
                        BucketItem bucket;
                        ItemStack pickedUpStack = bucketPickup.m_142598_((LevelAccessor)this.f_58857_, pos, blockState);
                        if (pickedUpStack.m_41619_()) {
                            return false;
                        }
                        Item item = pickedUpStack.m_41720_();
                        if (item instanceof BucketItem && !this.validFluid(fluidStack = this.getOutput(sourceFluid = (bucket = (BucketItem)item).getFluid(), hasFilter), false)) {
                            Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.m_76152_(), (Object)pos, (Object)this.f_58857_, (Object)sourceFluid);
                            return false;
                        }
                    }
                    this.suck(fluidStack, pos, addRecurring);
                    return true;
                }
            }
        }
        return false;
    }

    private FluidStack getOutput(Fluid sourceFluid, boolean hasFilter) {
        if (hasFilter && sourceFluid == Fluids.f_76193_) {
            return MekanismFluids.HEAVY_WATER.getFluidStack(10);
        }
        return new FluidStack(sourceFluid, 1000);
    }

    private void suck(@Nonnull FluidStack fluidStack, BlockPos pos, boolean addRecurring) {
        this.activeType = new FluidStack(fluidStack, 1);
        if (addRecurring) {
            this.recurringNodes.add(pos);
        }
        this.fluidTank.insert(fluidStack, Action.EXECUTE, AutomationType.INTERNAL);
        this.f_58857_.m_151555_(GameEvent.f_157816_, pos);
    }

    private boolean validFluid(@Nonnull FluidStack fluidStack, boolean recheckSize) {
        if (!fluidStack.isEmpty() && (this.activeType.isEmpty() || this.activeType.isFluidEqual(fluidStack))) {
            if (this.fluidTank.isEmpty()) {
                return true;
            }
            if (this.fluidTank.isFluidEqual(fluidStack)) {
                return !recheckSize || fluidStack.getAmount() <= this.fluidTank.getNeeded();
            }
        }
        return false;
    }

    public void reset() {
        this.activeType = FluidStack.EMPTY;
        this.recurringNodes.clear();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("progress", this.operatingTicks);
        if (!this.activeType.isEmpty()) {
            nbtTags.m_128365_("fluid", (Tag)this.activeType.writeToNBT(new CompoundTag()));
        }
        if (!this.recurringNodes.isEmpty()) {
            ListTag recurringList = new ListTag();
            for (BlockPos nodePos : this.recurringNodes) {
                recurringList.add((Object)NbtUtils.m_129224_((BlockPos)nodePos));
            }
            nbtTags.m_128365_("recurringNodes", (Tag)recurringList);
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.operatingTicks = nbt.m_128451_("progress");
        NBTUtils.setFluidStackIfPresent(nbt, "fluid", fluid -> {
            this.activeType = fluid;
        });
        if (nbt.m_128425_("recurringNodes", 9)) {
            ListTag tagList = nbt.m_128437_("recurringNodes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.recurringNodes.add(NbtUtils.m_129239_((CompoundTag)tagList.m_128728_(i)));
            }
        }
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        this.reset();
        player.m_6352_(MekanismUtils.logFormat(MekanismLang.PUMP_RESET), Util.f_137441_);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 19);
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.FLUID;
    }

    @Override
    public List<Component> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityElectricPump> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(nameOverride="reset")
    private void resetPump() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }
}

